/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.DomainManagerDialog;
import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.AbstractOkCancelDialog;
import com.jslope.framework.DomainManager;
import com.jslope.io.protocol.Address;
import com.jslope.security.Domain;
import com.jslope.security.utils.Validators;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class InstallDomainDialog
extends AbstractOkCancelDialog {
    private JTextField address;
    private JTextField serverID;
    private JTextField secretKey;
    private Domain domain;

    private InstallDomainDialog(Domain domain) {
        super(MainWindow.getInstance(), "Install Domain on server", false);
        this.domain = domain;
        JLabel domainName = new JLabel(domain.getName());
        this.addComponent("domainName:", domainName);
        this.address = new JTextField(15);
        this.addComponent("address:", this.address);
        this.serverID = new JTextField(15);
        this.addComponent("server id", this.serverID);
        this.secretKey = new JTextField(15);
        this.addComponent("secret key", this.secretKey);
        this.finishDialog();
    }

    @Override
    protected boolean validateAction() {
        String serverAddress = this.getServerAddress();
        String serverID = this.getServerID();
        String secretKey = this.getSecretKey();
        if (!Validators.validateAddress(serverAddress)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid server address", "Server address is invalid", 0);
            return false;
        }
        if (!Validators.validateIDName(serverID)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid server ID", "Server ID is invalid", 0);
            return false;
        }
        return DomainManager.installDomainOnServer(this.domain, new Address(serverAddress), serverID, secretKey, new UIErrorHandler(DomainManagerDialog.getInstance()));
    }

    private String getSecretKey() {
        return this.secretKey.getText();
    }

    private String getServerAddress() {
        return this.address.getText();
    }

    private String getServerID() {
        return this.serverID.getText();
    }

    public static void installDomain(Domain selectedDomain) {
        new InstallDomainDialog(selectedDomain).setVisible(true);
    }
}

