/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.domainmanager;

import com.jslope.client.domainmanager.DomainManagerDialog;
import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.AbstractOkCancelDialog;
import com.jslope.client.ui.dialog.SubdomainDialogField;
import com.jslope.client.ui.dialog.impl.SubdomainEditField;
import com.jslope.io.Config;
import com.jslope.security.Domain;
import com.jslope.security.PublicDomain;
import com.jslope.security.crypto.impl.CryptogException;
import com.jslope.security.impl.DomainFactory;
import com.jslope.security.utils.Validators;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CreateSubdomainDialog
extends AbstractOkCancelDialog {
    private Domain domain;
    private SubdomainDialogField subdomainField;

    private CreateSubdomainDialog(Domain selectedDomain) {
        super(MainWindow.getInstance(), "Create Subdomain locally", false);
        this.domain = selectedDomain;
        JLabel domainName = new JLabel(selectedDomain.getName());
        this.addComponent("domainName:", domainName);
        this.subdomainField = new SubdomainEditField(this.domain, "Name:");
        this.addComponent(this.subdomainField);
        this.finishDialog();
    }

    @Override
    protected boolean validateAction() {
        String subdomainName = this.getSubdomainName();
        String fullDomainName = DomainFactory.subdomainName(subdomainName, this.domain.getName());
        if (!Validators.validateSubdomain(subdomainName)) {
            JOptionPane.showMessageDialog(this, "Please enter a valid subdomain name, it shouldn't contain dots", "Subdomain name is invalid", 0);
            return false;
        }
        UIErrorHandler errorHandler = new UIErrorHandler(DomainManagerDialog.getInstance());
        Domain newDomain = DomainFactory.newDomain(fullDomainName);
        PublicDomain publicDomain = newDomain.getPublicPart();
        try {
            this.domain.getPublicPart().verifyInternalSignature();
            this.domain.signSubdomain(publicDomain);
            newDomain.reintegrate(publicDomain);
            newDomain.getPublicPart().verifyInternalSignature();
            newDomain.saveToDirectory(new File(Config.getDomainsDirectory()));
            newDomain.saveToFile();
            DomainManagerDialog.renewDomains();
        }
        catch (CryptogException e) {
            e.printStackTrace();
            errorHandler.addError(e);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            errorHandler.addError(e);
            return false;
        }
        return true;
    }

    private String getSubdomainName() {
        return this.subdomainField.getPrefixIDName();
    }

    public static void createSubdomain(Domain selectedDomain) {
        new CreateSubdomainDialog(selectedDomain).setVisible(true);
    }
}

