/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.app;

import com.jslope.client.app.ErrorHandlerCreator;
import com.jslope.client.domainmanager.DomainList;
import com.jslope.client.io.serverlistener.ClientServerListener;
import com.jslope.client.io.serverlistener.ServerListener;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.persistent.WaitingUnsignedID;
import com.jslope.framework.DomainManager;
import com.jslope.io.protocol.ClientHandler;
import com.jslope.io.protocol.ServerEvent;
import com.jslope.io.protocol.errorhandling.ErrorHandler;
import com.jslope.security.Domain;
import com.jslope.security.PublicID;
import java.util.Set;

public class RealClientHandler
implements ClientHandler {
    private static RealClientHandler instance = new RealClientHandler();
    private static ErrorHandlerCreator errorHandlerCreator;

    @Override
    public void processListenToServerEvent(String domainName, ServerEvent event) {
        Domain domain = DomainList.getDomain(domainName);
        Set<PublicID> signedIDs = DomainManager.signIDsOnServer(domain, MainWindow.getNewSystemErrorHandler());
        WaitingUnsignedID.removeSignedIDs(signedIDs);
    }

    @Override
    public void processListenToClientServerEvent(String idName, ServerEvent event) {
        AccountRecord.checkSignature(idName);
    }

    @Override
    public boolean areThereMoreActionsToWaitFrom(String domainName) {
        return ServerListener.areThereMoreWaitingForDomain(domainName);
    }

    @Override
    public boolean areThereMoreActionsToWaitForClient(String idName) {
        return ClientServerListener.areThereMoreWaitingForID(idName);
    }

    public static ClientHandler getInstance() {
        return instance;
    }

    public static void setErrorHandlerCreator(ErrorHandlerCreator creator) {
        errorHandlerCreator = creator;
    }

    public static ErrorHandler getNewSystemErrorHandler() {
        return errorHandlerCreator.getNewErrorHandler();
    }
}

