/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.app;

import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.persistent.MessageRecord;
import com.jslope.io.protocol.messages.OpenMessage;
import com.jslope.logger.Log;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.impl.CryptogException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class ClientMessageDispatcher
implements Runnable {
    BlockingQueue<MessageRecord> localDispatcher = new LinkedBlockingQueue<MessageRecord>();

    ClientMessageDispatcher() {
    }

    public void dispatchMessage(MessageRecord message) throws CryptogException {
        Log.debug("Dispatching message: " + message);
        SecureID fromID = message.getFromID();
        OpenMessage unsignedMessage = message.createOpenMessage();
        if (fromID.sendMessage(unsignedMessage, MainWindow.getNewSystemErrorHandler())) {
            message.moveToSendFolder();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    MessageRecord message = this.localDispatcher.take();
                    this.dispatchMessage(message);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void putInQueue(MessageRecord message) throws InterruptedException {
        this.localDispatcher.put(message);
    }
}

