/*
 * Decompiled with CFR 0.152.
 */
package com.jslope.client.account;

import com.jslope.client.io.serverlistener.ClientServerListener;
import com.jslope.client.protocol.UIErrorHandler;
import com.jslope.client.ui.MainWindow;
import com.jslope.client.ui.dialog.AbstractOkCancelDialog;
import com.jslope.client.ui.model.DirectoryTreeModel;
import com.jslope.client.ui.persistent.AccountRecord;
import com.jslope.client.ui.utils.SwingQueue;
import com.jslope.framework.DomainManager;
import com.jslope.logger.Log;
import com.jslope.security.SecureID;
import com.jslope.security.crypto.utils.JSlopeRandom;
import com.jslope.security.impl.IDFactory;
import com.jslope.security.utils.Validators;
import com.jslope.uirandom.JSeederDialog;
import java.awt.Cursor;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CreateAccountDialog
extends AbstractOkCancelDialog {
    private JCheckBox additionalRandom;
    private JTextField idNameField = new JTextField(15);
    private JTextField secretKeyField;
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static final Cursor waitCursor = Cursor.getPredefinedCursor(3);

    private CreateAccountDialog() {
        super(MainWindow.getInstance(), "Create new account");
        this.addComponent("ID name:", this.idNameField);
        this.secretKeyField = new JTextField(15);
        this.addComponent("secret key", this.secretKeyField);
        this.additionalRandom = new JCheckBox("additional randomizer");
        this.addComponent(this.additionalRandom);
        this.finishDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean validateAction() {
        String idName = this.idNameField.getText();
        String secretKey = this.secretKeyField.getText();
        boolean retVal = false;
        try {
            this.startWaitCursor();
            if (AccountRecord.accountExists(idName)) {
                JOptionPane.showMessageDialog(this, "There is already such ID on this system", "Entered ID already exists", 0);
                retVal = false;
            } else if (!Validators.validateIDName(idName)) {
                JOptionPane.showMessageDialog(this, "Please enter a valid ID", "Entered ID is invalid", 0);
                retVal = false;
            } else {
                Log.debug("Create Account 1: Validation passed for id: " + idName);
                if (this.additionalRandom.isSelected()) {
                    byte[] seed = JSeederDialog.getSeed(MainWindow.getInstance(), 20);
                    JSlopeRandom.addSeed(seed);
                }
                SecureID secureID = IDFactory.newID();
                secureID.setName(idName);
                secureID.generate();
                Log.debug("Create Account 2: Secure id generated for id: " + idName);
                retVal = DomainManager.sendIDForSigning(secureID.getPublicPart(), secretKey, new UIErrorHandler(this));
                Log.debug("Create Account 3: Sent id for signing for id: " + idName + " retVal=" + retVal);
                if (retVal) {
                    DirectoryTreeModel.addAccount(secureID);
                    Log.debug("Create Account 4: account created for id: " + idName);
                    ClientServerListener.addListener(secureID);
                    Log.debug("Create Account 7: listener added for id: " + idName);
                }
            }
        }
        finally {
            this.stopWaitCursor();
        }
        return retVal;
    }

    private void startWaitCursor() {
        SwingQueue.invokeAndWaitNoEx(new Runnable(){

            @Override
            public void run() {
                CreateAccountDialog.this.setCursor(waitCursor);
            }
        });
    }

    private void showWaitingFrame() {
    }

    private void stopWaitCursor() {
        this.setCursor(defaultCursor);
    }

    public static void createAccount() {
        new CreateAccountDialog().setVisible(true);
    }
}

